//========================================================================================================================
//
//                                                     Mouse
//
//========================================================================================================================

//========================================================================================================================
//                                                     Object
//========================================================================================================================

function _mouse(image)
{
  this.x = GetMouseX(); // Mouse's X
  this.y = GetMouseY(); // Mouse's Y
  
  this.image = image || LoadImage("Mouse.png"); // Mouse's Image
  this.locked = false; // Used to lock onto one control despite of the mouse's location
  this.focus = undefined; // The control the mouse is currently using
  this.lastFocus = undefined; // Keeps record of the last control the mouse had used - Used to stop issues with double click ie one click on one control and second click over another would perfom a double click on the second without this
  this.lastButton = undefined; // Keep record of the last button that was pressed - Also used for double click to avoid a left followed by a right click initiating the double click on right click funciton
  
  this.held = false; // Registers if mouse button held and if on click has been performed all ready
  this.time = 0; // Timer used for double click
  this.doubleClick = false; // Used to default to double click instead of regular click
}

//========================================================================================================================
//                                                     Update
//========================================================================================================================

_mouse.prototype.update = function()
{
  this.x = GetMouseX();
  this.y = GetMouseY();
  
  while (GetNumMouseWheelEvents())
  {
    if (this.focus)
    {
      switch (GetMouseWheelEvent())
      {
        case MOUSE_WHEEL_UP: if (this.focus.wheelScrollUp && this.focus.wheelScrollUp) return this.lastFocus.wheelScrollUp();
        case MOUSE_WHEEL_DOWN: if (this.focus.wheelScrollDown && this.focus.wheelScrollUp) return this.lastFocus.wheelScrollDown();
      }
    }
  }
  if (this.isButtonPressed() != -1 && IsMouseButtonPressed(this.isButtonPressed()))
  {
    if (this.held)
    {
      if (this.doubleClick) return// If mouse button held and this is the second click do nothing. Cant see a need for ON DOUBLE HOLD function?
      this.handleButton(1); // If not it is the first instance of a click so perform ON HOLD function
      return;
    }
    else
    {
      if (GetTime() > this.time + 150) // If this is a click and there wasnt a click within 150ms of this perform ON PRESS function as normal
      {
        // Set what we are over here
        this.lastFocus = this.focus; // Set last focus to the current
        this.lastButton = this.isButtonPressed(); // Set what button was just pressed
        this.handleButton(0); // Run on pressed
        this.locked = true; // Lock the mouse to this event
        this.held = true; // Confirm mouse held
        return;
      }
      else // If not then this click IS within 150ms of the last so perform ON DOUBLE function
      {
        if (this.lastButton == this.isButtonPressed() && this.focus == this.lastFocus) // If the mouse is over the same object and if the button that has been pressed is the same as before double click
        {
          this.handleButton(3); // Run on double
          this.held = true; // Confirm mouse held
          this.doubleClick = true; // Confirm mouse was double clicked to prevent held and release events running
          return;
        }
        else // If the button that has been pressed is not the same as before forget double click
        {
          this.lastFocus = this.focus; // Set last focus to the current
          this.lastButton = this.isButtonPressed(); // Set what button was just pressed
          this.handleButton(0); // Run on pressed
          this.locked = true; // Lock mouse to this event
          this.held = true; // Confirm mouse held
          return;
        }
      }
    }
  }
  else
  {
    if (this.held)
    {
      if (this.doubleClick) // If button released and this is the second click just reset, cant see a need for a on double release function
      {
        this.locked = false; // Unlock the mouse
        this.held = false; // Confirm mouse released
        this.time = 0; // Reset stored time
        this.doubleClick = false; // Reset confirmation of double click
        return;
      }
      else // If not the button has been released after its press and its the first time so run ON RELEASE function
      {
        this.handleButton(2); // Run on release
        this.locked = false; // Unlock the mouse
        this.held = false; // Confirm mouse released
        this.time = GetTime(); // Store time to find double click
        return;
      }
    }
  }
}

_mouse.prototype.handleButton = function(i) // THIS WONT BE NEEDED LATER - TESTING PURPOSES
{
  if (this.focus) // If mouse focus is an appropriate control
  {
    switch(i)
    {
      case 0: // Handle if mouse is pressed for all 3 buttons
      {
        if (this.lastButton == 0 && this.focus.leftOnPress) this.focus.leftOnPress(); // Run on left press (if function exists)
        if (this.lastButton == 1 && this.focus.middleOnPress) this.focus.middleOnPress(); // Run on middle press (if function exists)
        if (this.lastButton == 2 && this.focus.rightOnPress) this.focus.rightOnPress(); // Run on right press (if function exists)
        //this.focus = undefined;
        return;
      }
      case 1: // Handle if mouse is held for all 3 buttons
      {
        if (this.lastButton == 0 && this.focus.leftOnHeld) this.focus.leftOnHeld(); // Run on left held (if function exists)
        if (this.lastButton == 1 && this.focus.middleOnHeld) this.focus.middleOnHeld(); // Run on middle held (if function exists)
        if (this.lastButton == 2 && this.focus.rightOnHeld) this.focus.rightOnHeld();  // Run of right held (if function exists)
        return;
      }
      case 2: // Handle if mouse is released for all 3 buttons
      {
        if (this.lastButton == 0 && this.focus.leftOnRelease) this.focus.leftOnRelease(); // Run on left release (if function exists)
        if (this.lastButton == 1 && this.focus.middleOnRelease) this.focus.middleOnRelease(); // Run on middle release (if function exists)
        if (this.lastButton == 2 && this.focus.rightOnRelease) this.focus.rightOnRelease(); // Run on right release (if function exists)
        return;
      }
      case 3: // Handle if mouse is double clicked for all 3 buttons AND check if double click is applicable else run normal on pressed event 
      {
        if (this.lastButton == 0) // Check and execute if last button pressed is left button
        {
          if (!this.focus.leftOnDouble && this.focus.leftOnPress) this.focus.leftOnPress(); // If there is no left double function run on press (if on press exists)
          else if (this.focus.leftOnDouble) this.focus.leftOnDouble(); // Else if left on double exists run that
        }
        if (this.lastButton == 1) // Check and execute if last button pressed is middle button
        {
          if (!this.focus.middleOnDouble && this.focus.middleOnPress) this.focus.middleOnPress(); // If there is no middle double function run on press (if on press exists)
          else if (this.focus.middleOnDouble) this.focus.middleOnDouble(); // Else if middle on double exists run that
        }
        if (this.lastButton == 2) // Check and execute if last button pressed is right button
        {
          if (!this.focus.rightOnDouble && this.focus.rightOnPress) this.focus.rightOnPress(); // If there is no right double function run on press (if on press exists)
          else if (this.focus.rightOnDouble) this.focus.rightOnDouble(); // Else if right on double exists run that
        }
        return;
      }
    }
  }
}

//========================================================================================================================
//                                                     Is Button Pressed
//========================================================================================================================
// Will return the number of the button pressed, no button will return -1
// 0 = MOUSE_LEFT
// 1 = MOUSE_MIDDLE
// 2 = MOUSE_RIGHT

_mouse.prototype.isButtonPressed = function()
{
  if (IsMouseButtonPressed(MOUSE_LEFT)) return MOUSE_LEFT; // If the mouse button is pressed return 0
  if (IsMouseButtonPressed(MOUSE_MIDDLE)) return MOUSE_MIDDLE; // If the mouse button is pressed return 1
  if (IsMouseButtonPressed(MOUSE_RIGHT)) return MOUSE_RIGHT; // If the mouse button is pressed return 2
  return -1; // If no button is pressed return -1 - this is because MOUSE_LEFT returns 0
}

//========================================================================================================================
//                                                     Is Mouse Over
//========================================================================================================================
// Will return if the mouse is over selected co-ords - if obj is passed to this function and the button is pressed then the mouse focus
// will attach to that control
// The way I use this would be to use isMouseOver from within the control and pass 'this' to it eg
// menu.prototype.handleMouse = function()
//{
//  if (mouse.isMouseOver(this.x, this.y, this.w, this.h) // Will return true or false if the mouse is over
//  if (mouse.isMouseOver(this.x, this.y, this.w, this.h, this) // Will return true or false if the mouse is over and if a mouse button is pressed it will set the mouse focus to 'this' also
//}

_mouse.prototype.isMouseOver = function(x, y, w, h, obj)
{
  this.x = GetMouseX();
  this.y = GetMouseY();
  if (this.x >= x && this.x < x + w && this.y >= y && this.y < y + h) // Check if mouse is over x, y, w, h
  {
    if (obj && !this.locked && this.isButtonPressed() > -1) this.focus = obj; // If it is and if obj arg was provided AND if a mouse button was pressed set new mouse focus
    return true; // Return true as the mouse is over the co-ords
  }
  return false; // return false if its not over the co-ords
}

//========================================================================================================================
//                                                     Number to Button
//========================================================================================================================
// Mouse buttons are returned as numbers in sphere so to this function will tell you what button relates to what number

_mouse.prototype.numberToButton = function(number) // For testing purposes, probably have no use
{
  if (number == 0) return "MOUSE_LEFT"; // To the mouse 0 is MOUSE_LEFT
  if (number == 1) return "MOUSE_MIDDLE"; // To the mouse 1 is MOUSE_MIDDLE
  if (number == 2) return "MOUSE_RIGHT"; // To the mouse 2 is MOUSE_RIGHT
}

//========================================================================================================================
//                                                     Render
//========================================================================================================================

_mouse.prototype.render = function()
{
  this.image.blit(this.x, this.y); // Blit the mouse cursor
}

